/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.sse;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.PerspectiveTransform;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.AccessHelper;
import com.sun.scenario.effect.impl.state.PerspectiveTransformState;
import com.sun.scenario.effect.impl.state.RenderState;
import com.sun.scenario.effect.impl.sw.sse.SSEEffectPeer;

public class SSEPerspectiveTransformPeer
extends SSEEffectPeer {
    public SSEPerspectiveTransformPeer(FilterContext fctx, Renderer r, String uniqueName) {
        super(fctx, r, uniqueName);
    }

    @Override
    protected final PerspectiveTransform getEffect() {
        return (PerspectiveTransform)super.getEffect();
    }

    private float[][] getITX() {
        PerspectiveTransformState state = (PerspectiveTransformState)AccessHelper.getState(this.getEffect());
        return state.getITX();
    }

    private float[] getTx0() {
        Rectangle ib = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float scalex = (float)ib.width / (float)nb.width;
        float[] itx0 = this.getITX()[0];
        return new float[]{itx0[0] * scalex, itx0[1] * scalex, itx0[2] * scalex};
    }

    private float[] getTx1() {
        Rectangle ib = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float scaley = (float)ib.height / (float)nb.height;
        float[] itx1 = this.getITX()[1];
        return new float[]{itx1[0] * scaley, itx1[1] * scaley, itx1[2] * scaley};
    }

    private float[] getTx2() {
        return this.getITX()[2];
    }

    @Override
    public int getTextureCoordinates(int inputIndex, float[] coords, float srcX, float srcY, float srcNativeWidth, float srcNativeHeight, Rectangle dstBounds, BaseTransform transform) {
        coords[0] = dstBounds.x;
        coords[1] = dstBounds.y;
        coords[2] = dstBounds.x + dstBounds.width;
        coords[3] = dstBounds.y + dstBounds.height;
        return 4;
    }

    @Override
    public ImageData filter(Effect effect, RenderState rstate, BaseTransform transform, Rectangle outputClip, ImageData ... inputs) {
        this.setEffect(effect);
        Rectangle dstBounds = this.getResultBounds(transform, outputClip, inputs);
        this.setDestBounds(dstBounds);
        HeapImage src0 = (HeapImage)inputs[0].getUntransformedImage();
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getPhysicalWidth();
        int src0h = src0.getPhysicalHeight();
        int src0scan = src0.getScanlineStride();
        int[] baseImg = src0.getPixelArray();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        Rectangle src0InputBounds = inputs[0].getUntransformedBounds();
        BaseTransform src0Transform = inputs[0].getTransform();
        this.setInputBounds(0, src0InputBounds);
        this.setInputNativeBounds(0, src0Bounds);
        float[] src0Rect = new float[4];
        this.getTextureCoordinates(0, src0Rect, src0InputBounds.x, src0InputBounds.y, src0w, src0h, dstBounds, src0Transform);
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        HeapImage dst = (HeapImage)((Object)this.getRenderer().getCompatibleImage(dstw, dsth));
        this.setDestNativeBounds(dst.getPhysicalWidth(), dst.getPhysicalHeight());
        int dstscan = dst.getScanlineStride();
        int[] dstPixels = dst.getPixelArray();
        float[] tx0_arr = this.getTx0();
        float[] tx1_arr = this.getTx1();
        float[] tx2_arr = this.getTx2();
        SSEPerspectiveTransformPeer.filter(dstPixels, 0, 0, dstw, dsth, dstscan, baseImg, src0Rect[0], src0Rect[1], src0Rect[2], src0Rect[3], src0w, src0h, src0scan, tx0_arr[0], tx0_arr[1], tx0_arr[2], tx1_arr[0], tx1_arr[1], tx1_arr[2], tx2_arr[0], tx2_arr[1], tx2_arr[2]);
        return new ImageData(this.getFilterContext(), dst, dstBounds);
    }

    private static native void filter(int[] var0, int var1, int var2, int var3, int var4, int var5, int[] var6, float var7, float var8, float var9, float var10, int var11, int var12, int var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22);
}

