/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Side;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.Chart;
import javafx.scene.layout.Region;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class PieChart
extends Chart {
    private static final int MIN_PIE_RADIUS = 25;
    private static final double LABEL_TICK_GAP = 6.0;
    private static final double LABEL_BALL_RADIUS = 2.0;
    private BitSet colorBits = new BitSet(8);
    private double centerX;
    private double centerY;
    private double pieRadius;
    private Data begin = null;
    private final Path labelLinePath = new Path(){

        @Override
        public boolean usesMirroring() {
            return false;
        }
    };
    private Legend legend = new Legend();
    private Data dataItemBeingRemoved = null;
    private Timeline dataRemoveTimeline = null;
    private final ListChangeListener<Data> dataChangeListener = c -> {
        while (c.next()) {
            Data item3;
            int i;
            if (c.wasPermutated()) {
                Data ptr = this.begin;
                for (int i2 = 0; i2 < this.getData().size(); ++i2) {
                    Data item2 = (Data)this.getData().get(i2);
                    this.updateDataItemStyleClass(item2, i2);
                    if (i2 == 0) {
                        ptr = this.begin = item2;
                        this.begin.next = null;
                        continue;
                    }
                    ptr.next = item2;
                    item2.next = null;
                    ptr = item2;
                }
                if (this.isLegendVisible()) {
                    this.updateLegend();
                }
                this.requestChartLayout();
                return;
            }
            for (i = c.getFrom(); i < c.getTo(); ++i) {
                item3 = (Data)this.getData().get(i);
                item3.setChart(this);
                if (this.begin == null) {
                    this.begin = item3;
                    this.begin.next = null;
                    continue;
                }
                if (i == 0) {
                    item3.next = this.begin;
                    this.begin = item3;
                    continue;
                }
                Data ptr = this.begin;
                for (int j = 0; j < i - 1; ++j) {
                    ptr = ptr.next;
                }
                item3.next = ptr.next;
                ptr.next = item3;
            }
            for (Data item3 : c.getRemoved()) {
                this.dataItemRemoved(item3);
            }
            for (i = c.getFrom(); i < c.getTo(); ++i) {
                item3 = (Data)this.getData().get(i);
                item3.defaultColorIndex = this.colorBits.nextClearBit(0);
                this.colorBits.set(item3.defaultColorIndex);
                this.dataItemAdded(item3, i);
            }
            if (!c.wasRemoved() && !c.wasAdded()) continue;
            for (i = 0; i < this.getData().size(); ++i) {
                item3 = (Data)this.getData().get(i);
                this.updateDataItemStyleClass(item3, i);
            }
            if (!this.isLegendVisible()) continue;
            this.updateLegend();
        }
        this.requestChartLayout();
    };
    private ObjectProperty<ObservableList<Data>> data = new ObjectPropertyBase<ObservableList<Data>>(){
        private ObservableList<Data> old;

        @Override
        protected void invalidated() {
            ObservableList current = (ObservableList)this.getValue();
            if (this.old != null) {
                this.old.removeListener(PieChart.this.dataChangeListener);
            }
            if (current != null) {
                current.addListener(PieChart.this.dataChangeListener);
            }
            if (this.old != null || current != null) {
                int toIndex;
                final List removed = this.old != null ? this.old : Collections.emptyList();
                int n = toIndex = current != null ? current.size() : 0;
                if (toIndex > 0 || !removed.isEmpty()) {
                    PieChart.this.dataChangeListener.onChanged(new NonIterableChange<Data>(0, toIndex, current){

                        @Override
                        public List<Data> getRemoved() {
                            return removed;
                        }

                        @Override
                        public boolean wasPermutated() {
                            return false;
                        }

                        @Override
                        protected int[] getPermutation() {
                            return new int[0];
                        }
                    });
                }
            } else if (this.old != null && this.old.size() > 0) {
                PieChart.this.dataChangeListener.onChanged(new NonIterableChange<Data>(0, 0, current){

                    @Override
                    public List<Data> getRemoved() {
                        return old;
                    }

                    @Override
                    public boolean wasPermutated() {
                        return false;
                    }

                    @Override
                    protected int[] getPermutation() {
                        return new int[0];
                    }
                });
            }
            this.old = current;
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "data";
        }
    };
    private DoubleProperty startAngle = new StyleableDoubleProperty(0.0){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "startAngle";
        }

        @Override
        public CssMetaData<PieChart, Number> getCssMetaData() {
            return StyleableProperties.START_ANGLE;
        }
    };
    private BooleanProperty clockwise = new StyleableBooleanProperty(true){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "clockwise";
        }

        @Override
        public CssMetaData<PieChart, Boolean> getCssMetaData() {
            return StyleableProperties.CLOCKWISE;
        }
    };
    private DoubleProperty labelLineLength = new StyleableDoubleProperty(20.0){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "labelLineLength";
        }

        @Override
        public CssMetaData<PieChart, Number> getCssMetaData() {
            return StyleableProperties.LABEL_LINE_LENGTH;
        }
    };
    private BooleanProperty labelsVisible = new StyleableBooleanProperty(true){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "labelsVisible";
        }

        @Override
        public CssMetaData<PieChart, Boolean> getCssMetaData() {
            return StyleableProperties.LABELS_VISIBLE;
        }
    };

    public final ObservableList<Data> getData() {
        return (ObservableList)this.data.getValue();
    }

    public final void setData(ObservableList<Data> value) {
        this.data.setValue(value);
    }

    public final ObjectProperty<ObservableList<Data>> dataProperty() {
        return this.data;
    }

    public final double getStartAngle() {
        return this.startAngle.getValue();
    }

    public final void setStartAngle(double value) {
        this.startAngle.setValue(value);
    }

    public final DoubleProperty startAngleProperty() {
        return this.startAngle;
    }

    public final void setClockwise(boolean value) {
        this.clockwise.setValue(value);
    }

    public final boolean isClockwise() {
        return this.clockwise.getValue();
    }

    public final BooleanProperty clockwiseProperty() {
        return this.clockwise;
    }

    public final double getLabelLineLength() {
        return this.labelLineLength.getValue();
    }

    public final void setLabelLineLength(double value) {
        this.labelLineLength.setValue(value);
    }

    public final DoubleProperty labelLineLengthProperty() {
        return this.labelLineLength;
    }

    public final void setLabelsVisible(boolean value) {
        this.labelsVisible.setValue(value);
    }

    public final boolean getLabelsVisible() {
        return this.labelsVisible.getValue();
    }

    public final BooleanProperty labelsVisibleProperty() {
        return this.labelsVisible;
    }

    public PieChart() {
        this(FXCollections.observableArrayList());
    }

    public PieChart(ObservableList<Data> data) {
        this.getChartChildren().add(this.labelLinePath);
        this.labelLinePath.getStyleClass().add("chart-pie-label-line");
        this.setLegend(this.legend);
        this.setData(data);
        this.useChartContentMirroring = false;
    }

    private void dataNameChanged(Data item) {
        item.textNode.setText(item.getName());
        this.requestChartLayout();
        this.updateLegend();
    }

    private void dataPieValueChanged(Data item) {
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(item.currentPieValueProperty(), item.getCurrentPieValue())), new KeyFrame(Duration.millis(500.0), new KeyValue(item.currentPieValueProperty(), item.getPieValue(), Interpolator.EASE_BOTH)));
        } else {
            item.setCurrentPieValue(item.getPieValue());
            this.requestChartLayout();
        }
    }

    private Node createArcRegion(Data item) {
        Node arcRegion = item.getNode();
        if (arcRegion == null) {
            arcRegion = new Region();
            arcRegion.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
            arcRegion.setPickOnBounds(false);
            item.setNode(arcRegion);
        }
        return arcRegion;
    }

    private Text createPieLabel(Data item) {
        Text text = item.textNode;
        text.setText(item.getName());
        return text;
    }

    private void updateDataItemStyleClass(Data item, int index) {
        Node node = item.getNode();
        if (node != null) {
            node.getStyleClass().setAll((String[])new String[]{"chart-pie", "data" + index, "default-color" + item.defaultColorIndex % 8});
            if (item.getPieValue() < 0.0) {
                node.getStyleClass().add("negative");
            }
        }
    }

    private void dataItemAdded(Data item, int index) {
        Node shape = this.createArcRegion(item);
        Text text = this.createPieLabel(item);
        item.getChart().getChartChildren().add(shape);
        if (this.shouldAnimate()) {
            if (this.dataRemoveTimeline != null && this.dataRemoveTimeline.getStatus().equals((Object)Animation.Status.RUNNING) && this.dataItemBeingRemoved == item) {
                this.dataRemoveTimeline.stop();
                this.dataRemoveTimeline = null;
                this.getChartChildren().remove(item.textNode);
                this.getChartChildren().remove(shape);
                this.removeDataItemRef(item);
            }
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(item.currentPieValueProperty(), item.getCurrentPieValue()), new KeyValue(item.radiusMultiplierProperty(), item.getRadiusMultiplier())), new KeyFrame(Duration.millis(500.0), actionEvent -> {
                text.setOpacity(0.0);
                if (item.getChart() == null) {
                    item.setChart(this);
                }
                item.getChart().getChartChildren().add(text);
                FadeTransition ft = new FadeTransition(Duration.millis(150.0), text);
                ft.setToValue(1.0);
                ft.play();
            }, new KeyValue(item.currentPieValueProperty(), item.getPieValue(), Interpolator.EASE_BOTH), new KeyValue(item.radiusMultiplierProperty(), 1, Interpolator.EASE_BOTH)));
        } else {
            this.getChartChildren().add(text);
            item.setRadiusMultiplier(1.0);
            item.setCurrentPieValue(item.getPieValue());
        }
        for (int i = 0; i < this.getChartChildren().size(); ++i) {
            Node n = (Node)this.getChartChildren().get(i);
            if (!(n instanceof Text)) continue;
            n.toFront();
        }
    }

    private void removeDataItemRef(Data item) {
        if (this.begin == item) {
            this.begin = item.next;
        } else {
            Data ptr = this.begin;
            while (ptr != null && ptr.next != item) {
                ptr = ptr.next;
            }
            if (ptr != null) {
                ptr.next = item.next;
            }
        }
    }

    private Timeline createDataRemoveTimeline(final Data item) {
        Node shape = item.getNode();
        Timeline t = new Timeline();
        t.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(item.currentPieValueProperty(), item.getCurrentPieValue()), new KeyValue(item.radiusMultiplierProperty(), item.getRadiusMultiplier())), new KeyFrame(Duration.millis(500.0), actionEvent -> {
            this.colorBits.clear(item.defaultColorIndex);
            this.getChartChildren().remove(shape);
            FadeTransition ft = new FadeTransition(Duration.millis(150.0), item.textNode);
            ft.setFromValue(1.0);
            ft.setToValue(0.0);
            ft.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    PieChart.this.getChartChildren().remove(item.textNode);
                    item.setChart(null);
                    PieChart.this.removeDataItemRef(item);
                    item.textNode.setOpacity(1.0);
                }
            });
            ft.play();
        }, new KeyValue(item.currentPieValueProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(item.radiusMultiplierProperty(), 0))});
        return t;
    }

    private void dataItemRemoved(Data item) {
        Node shape = item.getNode();
        if (this.shouldAnimate()) {
            this.dataRemoveTimeline = this.createDataRemoveTimeline(item);
            this.dataItemBeingRemoved = item;
            this.animate(this.dataRemoveTimeline);
        } else {
            this.colorBits.clear(item.defaultColorIndex);
            this.getChartChildren().remove(item.textNode);
            this.getChartChildren().remove(shape);
            item.setChart(null);
            this.removeDataItemRef(item);
        }
    }

    @Override
    protected void layoutChartChildren(double top, double left, double contentWidth, double contentHeight) {
        this.centerX = contentWidth / 2.0 + left;
        this.centerY = contentHeight / 2.0 + top;
        double total = 0.0;
        Data item = this.begin;
        while (item != null) {
            total += Math.abs(item.getCurrentPieValue());
            item = item.next;
        }
        double scale = total != 0.0 ? 360.0 / total : 0.0;
        this.labelLinePath.getElements().clear();
        double[] labelsX = null;
        double[] labelsY = null;
        double[] labelAngles = null;
        double labelScale = 1.0;
        ArrayList<LabelLayoutInfo> fullPie = null;
        boolean shouldShowLabels = this.getLabelsVisible();
        if (this.getLabelsVisible()) {
            double xPad = 0.0;
            double yPad = 0.0;
            labelsX = new double[this.getDataSize()];
            labelsY = new double[this.getDataSize()];
            labelAngles = new double[this.getDataSize()];
            fullPie = new ArrayList<LabelLayoutInfo>();
            int index = 0;
            double start = this.getStartAngle();
            Data item2 = this.begin;
            while (item2 != null) {
                item2.textNode.getTransforms().clear();
                double size = this.isClockwise() ? -scale * Math.abs(item2.getCurrentPieValue()) : scale * Math.abs(item2.getCurrentPieValue());
                labelAngles[index] = PieChart.normalizeAngle(start + size / 2.0);
                double sproutX = PieChart.calcX(labelAngles[index], this.getLabelLineLength(), 0.0);
                double sproutY = PieChart.calcY(labelAngles[index], this.getLabelLineLength(), 0.0);
                labelsX[index] = sproutX;
                labelsY[index] = sproutY;
                xPad = Math.max(xPad, 2.0 * (item2.textNode.getLayoutBounds().getWidth() + 6.0 + Math.abs(sproutX)));
                yPad = sproutY > 0.0 ? Math.max(yPad, 2.0 * Math.abs(sproutY + item2.textNode.getLayoutBounds().getMaxY())) : Math.max(yPad, 2.0 * Math.abs(sproutY + item2.textNode.getLayoutBounds().getMinY()));
                start += size;
                ++index;
                item2 = item2.next;
            }
            this.pieRadius = Math.min(contentWidth - xPad, contentHeight - yPad) / 2.0;
            if (this.pieRadius < 25.0) {
                double roomX = contentWidth - 25.0 - 25.0;
                double roomY = contentHeight - 25.0 - 25.0;
                labelScale = Math.min(roomX / xPad, roomY / yPad);
                if (this.begin == null && labelScale < 0.7 || this.begin.textNode.getFont().getSize() * labelScale < 9.0) {
                    shouldShowLabels = false;
                    labelScale = 1.0;
                } else {
                    this.pieRadius = 25.0;
                    for (int i = 0; i < labelsX.length; ++i) {
                        labelsX[i] = labelsX[i] * labelScale;
                        labelsY[i] = labelsY[i] * labelScale;
                    }
                }
            }
        }
        if (!shouldShowLabels) {
            this.pieRadius = Math.min(contentWidth, contentHeight) / 2.0;
        }
        if (this.getChartChildren().size() > 0) {
            int index = 0;
            Data item3 = this.begin;
            while (item3 != null) {
                item3.textNode.setVisible(shouldShowLabels);
                if (shouldShowLabels) {
                    double size = this.isClockwise() ? -scale * Math.abs(item3.getCurrentPieValue()) : scale * Math.abs(item3.getCurrentPieValue());
                    boolean isLeftSide = !(labelAngles[index] > -90.0) || !(labelAngles[index] < 90.0);
                    double sliceCenterEdgeX = PieChart.calcX(labelAngles[index], this.pieRadius, this.centerX);
                    double sliceCenterEdgeY = PieChart.calcY(labelAngles[index], this.pieRadius, this.centerY);
                    double xval = isLeftSide ? labelsX[index] + sliceCenterEdgeX - item3.textNode.getLayoutBounds().getMaxX() - 6.0 : labelsX[index] + sliceCenterEdgeX - item3.textNode.getLayoutBounds().getMinX() + 6.0;
                    double yval = labelsY[index] + sliceCenterEdgeY - item3.textNode.getLayoutBounds().getMinY() / 2.0 - 2.0;
                    double lineEndX = sliceCenterEdgeX + labelsX[index];
                    double lineEndY = sliceCenterEdgeY + labelsY[index];
                    LabelLayoutInfo info = new LabelLayoutInfo(sliceCenterEdgeX, sliceCenterEdgeY, lineEndX, lineEndY, xval, yval, item3.textNode, Math.abs(size));
                    fullPie.add(info);
                    if (labelScale < 1.0) {
                        item3.textNode.getTransforms().add(new Scale(labelScale, labelScale, isLeftSide ? item3.textNode.getLayoutBounds().getWidth() : 0.0, 0.0));
                    }
                }
                ++index;
                item3 = item3.next;
            }
            this.resolveCollision(fullPie);
            double sAngle = this.getStartAngle();
            Data item4 = this.begin;
            while (item4 != null) {
                Node node = item4.getNode();
                Arc arc = null;
                if (node != null && node instanceof Region) {
                    Region arcRegion = (Region)node;
                    if (arcRegion.getShape() == null) {
                        arc = new Arc();
                        arcRegion.setShape(arc);
                    } else {
                        arc = (Arc)arcRegion.getShape();
                    }
                    arcRegion.setShape(null);
                    arcRegion.setShape(arc);
                    arcRegion.setScaleShape(false);
                    arcRegion.setCenterShape(false);
                    arcRegion.setCacheShape(false);
                }
                double size = this.isClockwise() ? -scale * Math.abs(item4.getCurrentPieValue()) : scale * Math.abs(item4.getCurrentPieValue());
                arc.setStartAngle(sAngle);
                arc.setLength(size);
                arc.setType(ArcType.ROUND);
                arc.setRadiusX(this.pieRadius * item4.getRadiusMultiplier());
                arc.setRadiusY(this.pieRadius * item4.getRadiusMultiplier());
                node.setLayoutX(this.centerX);
                node.setLayoutY(this.centerY);
                sAngle += size;
                item4 = item4.next;
            }
            if (fullPie != null) {
                for (LabelLayoutInfo info : fullPie) {
                    if (!info.text.isVisible()) continue;
                    this.drawLabelLinePath(info);
                }
            }
        }
    }

    private void resolveCollision(ArrayList<LabelLayoutInfo> list) {
        int boxH = this.begin != null ? (int)this.begin.textNode.getLayoutBounds().getHeight() : 0;
        int i = 0;
        for (int j = 1; list != null && j < list.size(); ++j) {
            LabelLayoutInfo box1 = list.get(i);
            LabelLayoutInfo box2 = list.get(j);
            if (box1.text.isVisible() && box2.text.isVisible() && (this.fuzzyGT(box2.textY, box1.textY) ? this.fuzzyLT(box2.textY - (double)boxH - box1.textY, 2.0) : this.fuzzyLT(box1.textY - (double)boxH - box2.textY, 2.0)) && (this.fuzzyGT(box1.textX, box2.textX) ? this.fuzzyLT(box1.textX - box2.textX, box2.text.prefWidth(-1.0)) : this.fuzzyLT(box2.textX - box1.textX, box1.text.prefWidth(-1.0)))) {
                if (this.fuzzyLT(box1.size, box2.size)) {
                    box1.text.setVisible(false);
                    i = j;
                    continue;
                }
                box2.text.setVisible(false);
                continue;
            }
            i = j;
        }
    }

    private int fuzzyCompare(double o1, double o2) {
        double fuzz = 1.0E-5;
        return Math.abs(o1 - o2) < fuzz ? 0 : (o1 < o2 ? -1 : 1);
    }

    private boolean fuzzyGT(double o1, double o2) {
        return this.fuzzyCompare(o1, o2) == 1;
    }

    private boolean fuzzyLT(double o1, double o2) {
        return this.fuzzyCompare(o1, o2) == -1;
    }

    private void drawLabelLinePath(LabelLayoutInfo info) {
        info.text.setLayoutX(info.textX);
        info.text.setLayoutY(info.textY);
        this.labelLinePath.getElements().add(new MoveTo(info.startX, info.startY));
        this.labelLinePath.getElements().add(new LineTo(info.endX, info.endY));
        this.labelLinePath.getElements().add(new MoveTo(info.endX - 2.0, info.endY));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, info.endX, info.endY - 2.0, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, info.endX + 2.0, info.endY, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, info.endX, info.endY + 2.0, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, info.endX - 2.0, info.endY, false, true));
        this.labelLinePath.getElements().add(new ClosePath());
    }

    private void updateLegend() {
        Node legendNode = this.getLegend();
        if (legendNode != null && legendNode != this.legend) {
            return;
        }
        this.legend.setVertical(this.getLegendSide().equals((Object)Side.LEFT) || this.getLegendSide().equals((Object)Side.RIGHT));
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (Data item : this.getData()) {
                Legend.LegendItem legenditem = new Legend.LegendItem(item.getName());
                legenditem.getSymbol().getStyleClass().addAll((Collection<String>)item.getNode().getStyleClass());
                legenditem.getSymbol().getStyleClass().add("pie-legend-symbol");
                this.legend.getItems().add(legenditem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (legendNode == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    private int getDataSize() {
        int count = 0;
        Data d = this.begin;
        while (d != null) {
            ++count;
            d = d.next;
        }
        return count;
    }

    private static double calcX(double angle, double radius, double centerX) {
        return centerX + radius * Math.cos(Math.toRadians(-angle));
    }

    private static double calcY(double angle, double radius, double centerY) {
        return centerY + radius * Math.sin(Math.toRadians(-angle));
    }

    private static double normalizeAngle(double angle) {
        double a = angle % 360.0;
        if (a <= -180.0) {
            a += 360.0;
        }
        if (a > 180.0) {
            a -= 360.0;
        }
        return a;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return PieChart.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<PieChart, Boolean> CLOCKWISE = new CssMetaData<PieChart, Boolean>("-fx-clockwise", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(PieChart node) {
                return node.clockwise == null || !node.clockwise.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(PieChart node) {
                return (StyleableProperty)((Object)node.clockwiseProperty());
            }
        };
        private static final CssMetaData<PieChart, Boolean> LABELS_VISIBLE = new CssMetaData<PieChart, Boolean>("-fx-pie-label-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(PieChart node) {
                return node.labelsVisible == null || !node.labelsVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(PieChart node) {
                return (StyleableProperty)((Object)node.labelsVisibleProperty());
            }
        };
        private static final CssMetaData<PieChart, Number> LABEL_LINE_LENGTH = new CssMetaData<PieChart, Number>("-fx-label-line-length", SizeConverter.getInstance(), (Number)20.0){

            @Override
            public boolean isSettable(PieChart node) {
                return node.labelLineLength == null || !node.labelLineLength.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(PieChart node) {
                return (StyleableProperty)((Object)node.labelLineLengthProperty());
            }
        };
        private static final CssMetaData<PieChart, Number> START_ANGLE = new CssMetaData<PieChart, Number>("-fx-start-angle", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(PieChart node) {
                return node.startAngle == null || !node.startAngle.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(PieChart node) {
                return (StyleableProperty)((Object)node.startAngleProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Chart.getClassCssMetaData());
            styleables.add(CLOCKWISE);
            styleables.add(LABELS_VISIBLE);
            styleables.add(LABEL_LINE_LENGTH);
            styleables.add(START_ANGLE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static final class Data {
        private Text textNode = new Text();
        private Data next = null;
        private int defaultColorIndex;
        private ReadOnlyObjectWrapper<PieChart> chart = new ReadOnlyObjectWrapper(this, "chart");
        private StringProperty name = new StringPropertyBase(){

            @Override
            protected void invalidated() {
                if (this.getChart() != null) {
                    this.getChart().dataNameChanged(this);
                }
            }

            @Override
            public Object getBean() {
                return this;
            }

            @Override
            public String getName() {
                return "name";
            }
        };
        private DoubleProperty pieValue = new DoublePropertyBase(){

            @Override
            protected void invalidated() {
                if (this.getChart() != null) {
                    this.getChart().dataPieValueChanged(this);
                }
            }

            @Override
            public Object getBean() {
                return this;
            }

            @Override
            public String getName() {
                return "pieValue";
            }
        };
        private DoubleProperty currentPieValue = new SimpleDoubleProperty(this, "currentPieValue");
        private DoubleProperty radiusMultiplier = new SimpleDoubleProperty(this, "radiusMultiplier");
        private ReadOnlyObjectWrapper<Node> node = new ReadOnlyObjectWrapper(this, "node");

        public final PieChart getChart() {
            return (PieChart)this.chart.getValue();
        }

        private void setChart(PieChart value) {
            this.chart.setValue(value);
        }

        public final ReadOnlyObjectProperty<PieChart> chartProperty() {
            return this.chart.getReadOnlyProperty();
        }

        public final void setName(String value) {
            this.name.setValue(value);
        }

        public final String getName() {
            return this.name.getValue();
        }

        public final StringProperty nameProperty() {
            return this.name;
        }

        public final double getPieValue() {
            return this.pieValue.getValue();
        }

        public final void setPieValue(double value) {
            this.pieValue.setValue(value);
        }

        public final DoubleProperty pieValueProperty() {
            return this.pieValue;
        }

        private double getCurrentPieValue() {
            return this.currentPieValue.getValue();
        }

        private void setCurrentPieValue(double value) {
            this.currentPieValue.setValue(value);
        }

        private DoubleProperty currentPieValueProperty() {
            return this.currentPieValue;
        }

        private double getRadiusMultiplier() {
            return this.radiusMultiplier.getValue();
        }

        private void setRadiusMultiplier(double value) {
            this.radiusMultiplier.setValue(value);
        }

        private DoubleProperty radiusMultiplierProperty() {
            return this.radiusMultiplier;
        }

        public Node getNode() {
            return (Node)this.node.getValue();
        }

        private void setNode(Node value) {
            this.node.setValue(value);
        }

        public ReadOnlyObjectProperty<Node> nodeProperty() {
            return this.node.getReadOnlyProperty();
        }

        public Data(String name, double value) {
            this.setName(name);
            this.setPieValue(value);
            this.textNode.getStyleClass().addAll((String[])new String[]{"text", "chart-pie-label"});
            this.textNode.setAccessibleRole(AccessibleRole.TEXT);
            this.textNode.setAccessibleRoleDescription("slice");
            this.textNode.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            this.textNode.accessibleTextProperty().bind(new StringBinding(){
                {
                    this.bind(this.nameProperty(), this.currentPieValueProperty());
                }

                @Override
                protected String computeValue() {
                    return this.getName() + " represents " + this.getCurrentPieValue() + " percent";
                }
            });
        }

        public String toString() {
            return "Data[" + this.getName() + "," + this.getPieValue() + "]";
        }
    }

    static final class LabelLayoutInfo {
        double startX;
        double startY;
        double endX;
        double endY;
        double textX;
        double textY;
        Text text;
        double size;

        public LabelLayoutInfo(double startX, double startY, double endX, double endY, double textX, double textY, Text text, double size) {
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
            this.textX = textX;
            this.textY = textY;
            this.text = text;
            this.size = size;
        }
    }
}

