/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.StyleConverterImpl;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import java.util.Map;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Paint;

class BackgroundConverter
extends StyleConverterImpl<ParsedValue[], Background> {
    static final StyleConverter<ParsedValue[], Background> INSTANCE = new BackgroundConverter();

    BackgroundConverter() {
    }

    @Override
    public Background convert(Map<CssMetaData<? extends Styleable, ?>, Object> convertedValues) {
        boolean hasImages;
        Paint[] fills = (Paint[])convertedValues.get(Background.BACKGROUND_COLOR);
        String[] imageUrls = (String[])convertedValues.get(Background.BACKGROUND_IMAGE);
        boolean hasFills = fills != null && fills.length > 0;
        boolean bl = hasImages = imageUrls != null && imageUrls.length > 0;
        if (!hasFills && !hasImages) {
            return null;
        }
        BackgroundFill[] backgroundFills = null;
        if (hasFills) {
            backgroundFills = new BackgroundFill[fills.length];
            Object tmp = convertedValues.get(Background.BACKGROUND_INSETS);
            Insets[] insets = tmp == null ? new Insets[]{} : (Insets[])tmp;
            tmp = convertedValues.get(Background.BACKGROUND_RADIUS);
            CornerRadii[] radii = tmp == null ? new CornerRadii[]{} : (CornerRadii[])tmp;
            int lastInsetsIndex = insets.length - 1;
            int lastRadiiIndex = radii.length - 1;
            for (int i = 0; i < fills.length; ++i) {
                Insets in;
                Insets insets2 = insets.length > 0 ? insets[i <= lastInsetsIndex ? i : lastInsetsIndex] : (in = Insets.EMPTY);
                CornerRadii ra = radii.length > 0 ? radii[i <= lastRadiiIndex ? i : lastRadiiIndex] : CornerRadii.EMPTY;
                backgroundFills[i] = new BackgroundFill(fills[i], ra, in);
            }
        }
        BackgroundImage[] backgroundImages = null;
        if (hasImages) {
            backgroundImages = new BackgroundImage[imageUrls.length];
            Object tmp = convertedValues.get(Background.BACKGROUND_REPEAT);
            RepeatStruct[] repeats = tmp == null ? new RepeatStruct[]{} : (RepeatStruct[])tmp;
            tmp = convertedValues.get(Background.BACKGROUND_POSITION);
            BackgroundPosition[] positions = tmp == null ? new BackgroundPosition[]{} : (BackgroundPosition[])tmp;
            tmp = convertedValues.get(Background.BACKGROUND_SIZE);
            BackgroundSize[] sizes = tmp == null ? new BackgroundSize[]{} : (BackgroundSize[])tmp;
            int lastRepeatIndex = repeats.length - 1;
            int lastPositionIndex = positions.length - 1;
            int lastSizeIndex = sizes.length - 1;
            for (int i = 0; i < imageUrls.length; ++i) {
                BackgroundPosition position;
                RepeatStruct repeat;
                Image image;
                if (imageUrls[i] == null || (image = StyleManager.getInstance().getCachedImage(imageUrls[i])) == null) continue;
                RepeatStruct repeatStruct = repeats.length > 0 ? repeats[i <= lastRepeatIndex ? i : lastRepeatIndex] : (repeat = null);
                BackgroundPosition backgroundPosition = positions.length > 0 ? positions[i <= lastPositionIndex ? i : lastPositionIndex] : (position = null);
                BackgroundSize size = sizes.length > 0 ? sizes[i <= lastSizeIndex ? i : lastSizeIndex] : null;
                backgroundImages[i] = new BackgroundImage(image, repeat == null ? null : repeat.repeatX, repeat == null ? null : repeat.repeatY, position, size);
            }
        }
        return new Background(backgroundFills, backgroundImages);
    }
}

