/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;

public class NGSubScene
extends NGNode {
    private float slWidth;
    private float slHeight;
    private double lastScaledW;
    private double lastScaledH;
    private RTTexture rtt;
    private RTTexture resolveRTT = null;
    private NGNode root = null;
    private boolean renderSG = true;
    private final boolean depthBuffer;
    private final boolean msaa;
    private Paint fillPaint;
    private NGCamera camera;
    private NGLightBase[] lights;
    private boolean isOpaque = false;
    static final double THRESHOLD = 0.00390625;

    public NGSubScene(boolean depthBuffer, boolean msaa) {
        this.depthBuffer = depthBuffer;
        this.msaa = msaa;
    }

    private NGSubScene() {
        this(false, false);
    }

    public void setRoot(NGNode root) {
        this.root = root;
    }

    public void setFillPaint(Object paint) {
        this.fillPaint = (Paint)paint;
    }

    public void setCamera(NGCamera camera) {
        this.camera = camera == null ? NGCamera.INSTANCE : camera;
    }

    public void setWidth(float width) {
        if (this.slWidth != width) {
            this.slWidth = width;
            this.geometryChanged();
            this.invalidateRTT();
        }
    }

    public void setHeight(float height) {
        if (this.slHeight != height) {
            this.slHeight = height;
            this.geometryChanged();
            this.invalidateRTT();
        }
    }

    public NGLightBase[] getLights() {
        return this.lights;
    }

    public void setLights(NGLightBase[] lights) {
        this.lights = lights;
    }

    public void markContentDirty() {
        this.visualsChanged();
    }

    @Override
    protected void visualsChanged() {
        this.renderSG = true;
        super.visualsChanged();
    }

    @Override
    protected void geometryChanged() {
        this.renderSG = true;
        super.geometryChanged();
    }

    private void invalidateRTT() {
        if (this.rtt != null) {
            this.rtt.dispose();
            this.rtt = null;
        }
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }

    private void applyBackgroundFillPaint(Graphics g) {
        this.isOpaque = true;
        if (this.fillPaint != null) {
            if (this.fillPaint instanceof Color) {
                Color fillColor = (Color)this.fillPaint;
                this.isOpaque = (double)fillColor.getAlpha() >= 1.0;
                g.clear(fillColor);
            } else {
                if (!this.fillPaint.isOpaque()) {
                    g.clear();
                    this.isOpaque = false;
                }
                g.setPaint(this.fillPaint);
                g.fillRect(0.0f, 0.0f, this.rtt.getContentWidth(), this.rtt.getContentHeight());
            }
        } else {
            this.isOpaque = false;
            g.clear();
        }
    }

    @Override
    public void renderForcedContent(Graphics gOptional) {
        this.root.renderForcedContent(gOptional);
    }

    private static double hypot(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    @Override
    protected void renderContent(Graphics g) {
        if ((double)this.slWidth <= 0.0 || (double)this.slHeight <= 0.0) {
            return;
        }
        BaseTransform txform = g.getTransformNoClone();
        double scaleX = NGSubScene.hypot(txform.getMxx(), txform.getMyx(), txform.getMzx());
        double scaleY = NGSubScene.hypot(txform.getMxy(), txform.getMyy(), txform.getMzy());
        double scaledW = (double)this.slWidth * scaleX;
        double scaledH = (double)this.slHeight * scaleY;
        int rtWidth = (int)Math.ceil(scaledW - 0.00390625);
        int rtHeight = (int)Math.ceil(scaledH - 0.00390625);
        if (Math.max(Math.abs(scaledW - this.lastScaledW), Math.abs(scaledH - this.lastScaledH)) > 0.00390625) {
            if (this.rtt != null && (rtWidth != this.rtt.getContentWidth() || rtHeight != this.rtt.getContentHeight())) {
                this.invalidateRTT();
            }
            this.renderSG = true;
            this.lastScaledW = scaledW;
            this.lastScaledH = scaledH;
        }
        if (this.rtt != null) {
            this.rtt.lock();
            if (this.rtt.isSurfaceLost()) {
                this.renderSG = true;
                this.rtt = null;
            }
        }
        if (this.renderSG || !this.root.isClean()) {
            if (this.rtt == null) {
                ResourceFactory factory = g.getResourceFactory();
                this.rtt = factory.createRTTexture(rtWidth, rtHeight, Texture.WrapMode.CLAMP_TO_ZERO, this.msaa);
            }
            Graphics rttGraphics = this.rtt.createGraphics();
            rttGraphics.scale((float)scaleX, (float)scaleY);
            rttGraphics.setLights(this.lights);
            rttGraphics.setDepthBuffer(this.depthBuffer);
            if (this.camera != null) {
                rttGraphics.setCamera(this.camera);
            }
            this.applyBackgroundFillPaint(rttGraphics);
            this.root.render(rttGraphics);
            this.root.clearDirtyTree();
            this.renderSG = false;
        }
        if (this.msaa) {
            int x0 = this.rtt.getContentX();
            int y0 = this.rtt.getContentY();
            int x1 = x0 + rtWidth;
            int y1 = y0 + rtHeight;
            if ((this.isOpaque || g.getCompositeMode() == CompositeMode.SRC) && NGSubScene.isDirectBlitTransform(txform, scaleX, scaleY) && !g.isDepthTest()) {
                int tx = (int)(txform.getMxt() + 0.5);
                int ty = (int)(txform.getMyt() + 0.5);
                RenderTarget target = g.getRenderTarget();
                int dstX0 = target.getContentX() + tx;
                int dstY0 = target.getContentY() + ty;
                int dstX1 = dstX0 + rtWidth;
                int dstY1 = dstY0 + rtHeight;
                int dstW = target.getContentWidth();
                int dstH = target.getContentHeight();
                int dX = dstX1 > dstW ? dstW - dstX1 : 0;
                int dY = dstY1 > dstH ? dstH - dstY1 : 0;
                g.blit(this.rtt, null, x0, y0, x1 + dX, y1 + dY, dstX0, dstY0, dstX1 + dX, dstY1 + dY);
            } else {
                if (this.resolveRTT != null && (this.resolveRTT.getContentWidth() < rtWidth || this.resolveRTT.getContentHeight() < rtHeight)) {
                    this.resolveRTT.dispose();
                    this.resolveRTT = null;
                }
                if (this.resolveRTT != null) {
                    this.resolveRTT.lock();
                    if (this.resolveRTT.isSurfaceLost()) {
                        this.resolveRTT = null;
                    }
                }
                if (this.resolveRTT == null) {
                    this.resolveRTT = g.getResourceFactory().createRTTexture(rtWidth, rtHeight, Texture.WrapMode.CLAMP_TO_ZERO, false);
                }
                this.resolveRTT.createGraphics().blit(this.rtt, this.resolveRTT, x0, y0, x1, y1, x0, y0, x1, y1);
                g.drawTexture(this.resolveRTT, 0.0f, 0.0f, (float)((double)rtWidth / scaleX), (float)((double)rtHeight / scaleY), 0.0f, 0.0f, rtWidth, rtHeight);
                this.resolveRTT.unlock();
            }
        } else {
            g.drawTexture(this.rtt, 0.0f, 0.0f, (float)((double)rtWidth / scaleX), (float)((double)rtHeight / scaleY), 0.0f, 0.0f, rtWidth, rtHeight);
        }
        this.rtt.unlock();
    }

    private static boolean isDirectBlitTransform(BaseTransform tx, double sx, double sy) {
        if (sx == 1.0 && sy == 1.0) {
            return tx.isTranslateOrIdentity();
        }
        if (!tx.is2D()) {
            return false;
        }
        return tx.getMxx() == sx && tx.getMxy() == 0.0 && tx.getMyx() == 0.0 && tx.getMyy() == sy;
    }

    public NGCamera getCamera() {
        return this.camera;
    }
}

