/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Spliterator;
import java.util.concurrent.CountedCompleter;
import java.util.function.IntFunction;
import java.util.stream.AbstractPipeline;
import java.util.stream.AbstractShortCircuitTask;
import java.util.stream.DoublePipeline;
import java.util.stream.DoubleStream;
import java.util.stream.IntPipeline;
import java.util.stream.IntStream;
import java.util.stream.LongPipeline;
import java.util.stream.LongStream;
import java.util.stream.Node;
import java.util.stream.Nodes;
import java.util.stream.PipelineHelper;
import java.util.stream.ReferencePipeline;
import java.util.stream.Sink;
import java.util.stream.Stream;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.StreamSpliterators;

final class SliceOps {
    private SliceOps() {
    }

    private static long calcSize(long l, long l2, long l3) {
        return l >= 0L ? Math.max(-1L, Math.min(l - l2, l3)) : -1L;
    }

    private static long calcSliceFence(long l, long l2) {
        long l3 = l2 >= 0L ? l + l2 : Long.MAX_VALUE;
        return l3 >= 0L ? l3 : Long.MAX_VALUE;
    }

    private static <P_IN> Spliterator<P_IN> sliceSpliterator(StreamShape streamShape, Spliterator<P_IN> spliterator, long l, long l2) {
        assert (spliterator.hasCharacteristics(16384));
        long l3 = SliceOps.calcSliceFence(l, l2);
        switch (streamShape) {
            case REFERENCE: {
                return new StreamSpliterators.SliceSpliterator.OfRef<P_IN>(spliterator, l, l3);
            }
            case INT_VALUE: {
                return new StreamSpliterators.SliceSpliterator.OfInt((Spliterator.OfInt)spliterator, l, l3);
            }
            case LONG_VALUE: {
                return new StreamSpliterators.SliceSpliterator.OfLong((Spliterator.OfLong)spliterator, l, l3);
            }
            case DOUBLE_VALUE: {
                return new StreamSpliterators.SliceSpliterator.OfDouble((Spliterator.OfDouble)spliterator, l, l3);
            }
        }
        throw new IllegalStateException("Unknown shape " + (Object)((Object)streamShape));
    }

    private static <T> IntFunction<T[]> castingArray() {
        return Object[]::new;
    }

    public static <T> Stream<T> makeRef(AbstractPipeline<?, T, ?> abstractPipeline, final long l, final long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Skip must be non-negative: " + l);
        }
        return new ReferencePipeline.StatefulOp<T, T>(abstractPipeline, StreamShape.REFERENCE, SliceOps.flags(l2)){

            Spliterator<T> unorderedSkipLimitSpliterator(Spliterator<T> spliterator, long l4, long l22, long l3) {
                if (l4 <= l3) {
                    l22 = l22 >= 0L ? Math.min(l22, l3 - l4) : l3 - l4;
                    l4 = 0L;
                }
                return new StreamSpliterators.UnorderedSliceSpliterator.OfRef(spliterator, l4, l22);
            }

            @Override
            <P_IN> Spliterator<T> opEvaluateParallelLazy(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator) {
                long l3 = pipelineHelper.exactOutputSizeIfKnown(spliterator);
                if (l3 > 0L && spliterator.hasCharacteristics(16384)) {
                    return new StreamSpliterators.SliceSpliterator.OfRef(pipelineHelper.wrapSpliterator(spliterator), l, SliceOps.calcSliceFence(l, l2));
                }
                if (!StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    return this.unorderedSkipLimitSpliterator(pipelineHelper.wrapSpliterator(spliterator), l, l2, l3);
                }
                return ((Node)new SliceTask(this, pipelineHelper, spliterator, SliceOps.castingArray(), l, l2).invoke()).spliterator();
            }

            @Override
            <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<T[]> intFunction) {
                long l3 = pipelineHelper.exactOutputSizeIfKnown(spliterator);
                if (l3 > 0L && spliterator.hasCharacteristics(16384)) {
                    Spliterator spliterator2 = SliceOps.sliceSpliterator(pipelineHelper.getSourceShape(), spliterator, l, l2);
                    return Nodes.collect(pipelineHelper, spliterator2, true, intFunction);
                }
                if (!StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    Spliterator spliterator3 = this.unorderedSkipLimitSpliterator(pipelineHelper.wrapSpliterator(spliterator), l, l2, l3);
                    return Nodes.collect(this, spliterator3, true, intFunction);
                }
                return (Node)new SliceTask(this, pipelineHelper, spliterator, intFunction, l, l2).invoke();
            }

            @Override
            Sink<T> opWrapSink(int n, Sink<T> sink) {
                return new Sink.ChainedReference<T, T>(sink){
                    long n;
                    long m;
                    {
                        super(sink);
                        this.n = l;
                        this.m = l2 >= 0L ? l2 : Long.MAX_VALUE;
                    }

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(SliceOps.calcSize(l, l, this.m));
                    }

                    @Override
                    public void accept(T t) {
                        if (this.n == 0L) {
                            if (this.m > 0L) {
                                --this.m;
                                this.downstream.accept(t);
                            }
                        } else {
                            --this.n;
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return this.m == 0L || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    public static IntStream makeInt(AbstractPipeline<?, Integer, ?> abstractPipeline, final long l, final long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Skip must be non-negative: " + l);
        }
        return new IntPipeline.StatefulOp<Integer>(abstractPipeline, StreamShape.INT_VALUE, SliceOps.flags(l2)){

            Spliterator.OfInt unorderedSkipLimitSpliterator(Spliterator.OfInt ofInt, long l4, long l22, long l3) {
                if (l4 <= l3) {
                    l22 = l22 >= 0L ? Math.min(l22, l3 - l4) : l3 - l4;
                    l4 = 0L;
                }
                return new StreamSpliterators.UnorderedSliceSpliterator.OfInt(ofInt, l4, l22);
            }

            @Override
            <P_IN> Spliterator<Integer> opEvaluateParallelLazy(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator) {
                long l3 = pipelineHelper.exactOutputSizeIfKnown(spliterator);
                if (l3 > 0L && spliterator.hasCharacteristics(16384)) {
                    return new StreamSpliterators.SliceSpliterator.OfInt((Spliterator.OfInt)pipelineHelper.wrapSpliterator(spliterator), l, SliceOps.calcSliceFence(l, l2));
                }
                if (!StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    return this.unorderedSkipLimitSpliterator((Spliterator.OfInt)pipelineHelper.wrapSpliterator(spliterator), l, l2, l3);
                }
                return ((Node)new SliceTask<P_IN, Integer>(this, pipelineHelper, spliterator, Integer[]::new, l, l2).invoke()).spliterator();
            }

            @Override
            <P_IN> Node<Integer> opEvaluateParallel(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<Integer[]> intFunction) {
                long l3 = pipelineHelper.exactOutputSizeIfKnown(spliterator);
                if (l3 > 0L && spliterator.hasCharacteristics(16384)) {
                    Spliterator spliterator2 = SliceOps.sliceSpliterator(pipelineHelper.getSourceShape(), spliterator, l, l2);
                    return Nodes.collectInt(pipelineHelper, spliterator2, true);
                }
                if (!StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    Spliterator.OfInt ofInt = this.unorderedSkipLimitSpliterator((Spliterator.OfInt)pipelineHelper.wrapSpliterator(spliterator), l, l2, l3);
                    return Nodes.collectInt(this, ofInt, true);
                }
                return (Node)new SliceTask<P_IN, Integer>(this, pipelineHelper, spliterator, intFunction, l, l2).invoke();
            }

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Integer> sink) {
                return new Sink.ChainedInt<Integer>(sink){
                    long n;
                    long m;
                    {
                        super(sink);
                        this.n = l;
                        this.m = l2 >= 0L ? l2 : Long.MAX_VALUE;
                    }

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(SliceOps.calcSize(l, l, this.m));
                    }

                    @Override
                    public void accept(int n) {
                        if (this.n == 0L) {
                            if (this.m > 0L) {
                                --this.m;
                                this.downstream.accept(n);
                            }
                        } else {
                            --this.n;
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return this.m == 0L || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    public static LongStream makeLong(AbstractPipeline<?, Long, ?> abstractPipeline, final long l, final long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Skip must be non-negative: " + l);
        }
        return new LongPipeline.StatefulOp<Long>(abstractPipeline, StreamShape.LONG_VALUE, SliceOps.flags(l2)){

            Spliterator.OfLong unorderedSkipLimitSpliterator(Spliterator.OfLong ofLong, long l4, long l22, long l3) {
                if (l4 <= l3) {
                    l22 = l22 >= 0L ? Math.min(l22, l3 - l4) : l3 - l4;
                    l4 = 0L;
                }
                return new StreamSpliterators.UnorderedSliceSpliterator.OfLong(ofLong, l4, l22);
            }

            @Override
            <P_IN> Spliterator<Long> opEvaluateParallelLazy(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator) {
                long l3 = pipelineHelper.exactOutputSizeIfKnown(spliterator);
                if (l3 > 0L && spliterator.hasCharacteristics(16384)) {
                    return new StreamSpliterators.SliceSpliterator.OfLong((Spliterator.OfLong)pipelineHelper.wrapSpliterator(spliterator), l, SliceOps.calcSliceFence(l, l2));
                }
                if (!StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    return this.unorderedSkipLimitSpliterator((Spliterator.OfLong)pipelineHelper.wrapSpliterator(spliterator), l, l2, l3);
                }
                return ((Node)new SliceTask<P_IN, Long>(this, pipelineHelper, spliterator, Long[]::new, l, l2).invoke()).spliterator();
            }

            @Override
            <P_IN> Node<Long> opEvaluateParallel(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<Long[]> intFunction) {
                long l3 = pipelineHelper.exactOutputSizeIfKnown(spliterator);
                if (l3 > 0L && spliterator.hasCharacteristics(16384)) {
                    Spliterator spliterator2 = SliceOps.sliceSpliterator(pipelineHelper.getSourceShape(), spliterator, l, l2);
                    return Nodes.collectLong(pipelineHelper, spliterator2, true);
                }
                if (!StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    Spliterator.OfLong ofLong = this.unorderedSkipLimitSpliterator((Spliterator.OfLong)pipelineHelper.wrapSpliterator(spliterator), l, l2, l3);
                    return Nodes.collectLong(this, ofLong, true);
                }
                return (Node)new SliceTask<P_IN, Long>(this, pipelineHelper, spliterator, intFunction, l, l2).invoke();
            }

            @Override
            Sink<Long> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){
                    long n;
                    long m;
                    {
                        super(sink);
                        this.n = l;
                        this.m = l2 >= 0L ? l2 : Long.MAX_VALUE;
                    }

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(SliceOps.calcSize(l, l, this.m));
                    }

                    @Override
                    public void accept(long l) {
                        if (this.n == 0L) {
                            if (this.m > 0L) {
                                --this.m;
                                this.downstream.accept(l);
                            }
                        } else {
                            --this.n;
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return this.m == 0L || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    public static DoubleStream makeDouble(AbstractPipeline<?, Double, ?> abstractPipeline, final long l, final long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Skip must be non-negative: " + l);
        }
        return new DoublePipeline.StatefulOp<Double>(abstractPipeline, StreamShape.DOUBLE_VALUE, SliceOps.flags(l2)){

            Spliterator.OfDouble unorderedSkipLimitSpliterator(Spliterator.OfDouble ofDouble, long l4, long l22, long l3) {
                if (l4 <= l3) {
                    l22 = l22 >= 0L ? Math.min(l22, l3 - l4) : l3 - l4;
                    l4 = 0L;
                }
                return new StreamSpliterators.UnorderedSliceSpliterator.OfDouble(ofDouble, l4, l22);
            }

            @Override
            <P_IN> Spliterator<Double> opEvaluateParallelLazy(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator) {
                long l3 = pipelineHelper.exactOutputSizeIfKnown(spliterator);
                if (l3 > 0L && spliterator.hasCharacteristics(16384)) {
                    return new StreamSpliterators.SliceSpliterator.OfDouble((Spliterator.OfDouble)pipelineHelper.wrapSpliterator(spliterator), l, SliceOps.calcSliceFence(l, l2));
                }
                if (!StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    return this.unorderedSkipLimitSpliterator((Spliterator.OfDouble)pipelineHelper.wrapSpliterator(spliterator), l, l2, l3);
                }
                return ((Node)new SliceTask<P_IN, Double>(this, pipelineHelper, spliterator, Double[]::new, l, l2).invoke()).spliterator();
            }

            @Override
            <P_IN> Node<Double> opEvaluateParallel(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<Double[]> intFunction) {
                long l3 = pipelineHelper.exactOutputSizeIfKnown(spliterator);
                if (l3 > 0L && spliterator.hasCharacteristics(16384)) {
                    Spliterator spliterator2 = SliceOps.sliceSpliterator(pipelineHelper.getSourceShape(), spliterator, l, l2);
                    return Nodes.collectDouble(pipelineHelper, spliterator2, true);
                }
                if (!StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    Spliterator.OfDouble ofDouble = this.unorderedSkipLimitSpliterator((Spliterator.OfDouble)pipelineHelper.wrapSpliterator(spliterator), l, l2, l3);
                    return Nodes.collectDouble(this, ofDouble, true);
                }
                return (Node)new SliceTask<P_IN, Double>(this, pipelineHelper, spliterator, intFunction, l, l2).invoke();
            }

            @Override
            Sink<Double> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){
                    long n;
                    long m;
                    {
                        super(sink);
                        this.n = l;
                        this.m = l2 >= 0L ? l2 : Long.MAX_VALUE;
                    }

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(SliceOps.calcSize(l, l, this.m));
                    }

                    @Override
                    public void accept(double d) {
                        if (this.n == 0L) {
                            if (this.m > 0L) {
                                --this.m;
                                this.downstream.accept(d);
                            }
                        } else {
                            --this.n;
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return this.m == 0L || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    private static int flags(long l) {
        return StreamOpFlag.NOT_SIZED | (l != -1L ? StreamOpFlag.IS_SHORT_CIRCUIT : 0);
    }

    private static final class SliceTask<P_IN, P_OUT>
    extends AbstractShortCircuitTask<P_IN, P_OUT, Node<P_OUT>, SliceTask<P_IN, P_OUT>> {
        private final AbstractPipeline<P_OUT, P_OUT, ?> op;
        private final IntFunction<P_OUT[]> generator;
        private final long targetOffset;
        private final long targetSize;
        private long thisNodeSize;
        private volatile boolean completed;

        SliceTask(AbstractPipeline<P_OUT, P_OUT, ?> abstractPipeline, PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<P_OUT[]> intFunction, long l, long l2) {
            super(pipelineHelper, spliterator);
            this.op = abstractPipeline;
            this.generator = intFunction;
            this.targetOffset = l;
            this.targetSize = l2;
        }

        SliceTask(SliceTask<P_IN, P_OUT> sliceTask, Spliterator<P_IN> spliterator) {
            super(sliceTask, spliterator);
            this.op = sliceTask.op;
            this.generator = sliceTask.generator;
            this.targetOffset = sliceTask.targetOffset;
            this.targetSize = sliceTask.targetSize;
        }

        @Override
        protected SliceTask<P_IN, P_OUT> makeChild(Spliterator<P_IN> spliterator) {
            return new SliceTask<P_IN, P_OUT>(this, spliterator);
        }

        @Override
        protected final Node<P_OUT> getEmptyResult() {
            return Nodes.emptyNode(this.op.getOutputShape());
        }

        @Override
        protected final Node<P_OUT> doLeaf() {
            if (this.isRoot()) {
                long l = StreamOpFlag.SIZED.isPreserved(this.op.sourceOrOpFlags) ? this.op.exactOutputSizeIfKnown(this.spliterator) : -1L;
                Node.Builder<P_OUT> builder = this.op.makeNodeBuilder(l, (IntFunction<P_OUT[]>)this.generator);
                Sink<P_OUT> sink = this.op.opWrapSink(this.helper.getStreamAndOpFlags(), builder);
                this.helper.copyIntoWithCancel(this.helper.wrapSink(sink), this.spliterator);
                return builder.build();
            }
            Node node = this.helper.wrapAndCopyInto(this.helper.makeNodeBuilder(-1L, this.generator), this.spliterator).build();
            this.thisNodeSize = node.count();
            this.completed = true;
            this.spliterator = null;
            return node;
        }

        @Override
        public final void onCompletion(CountedCompleter<?> countedCompleter) {
            if (!this.isLeaf()) {
                Object object;
                this.thisNodeSize = ((SliceTask)this.leftChild).thisNodeSize + ((SliceTask)this.rightChild).thisNodeSize;
                if (this.canceled) {
                    this.thisNodeSize = 0L;
                    object = this.getEmptyResult();
                } else {
                    object = this.thisNodeSize == 0L ? this.getEmptyResult() : (((SliceTask)this.leftChild).thisNodeSize == 0L ? (Node)((SliceTask)this.rightChild).getLocalResult() : Nodes.conc(this.op.getOutputShape(), (Node)((SliceTask)this.leftChild).getLocalResult(), (Node)((SliceTask)this.rightChild).getLocalResult()));
                }
                this.setLocalResult(this.isRoot() ? this.doTruncate((Node<P_OUT>)object) : object);
                this.completed = true;
            }
            if (this.targetSize >= 0L && !this.isRoot() && this.isLeftCompleted(this.targetOffset + this.targetSize)) {
                this.cancelLaterNodes();
            }
            super.onCompletion(countedCompleter);
        }

        @Override
        protected void cancel() {
            super.cancel();
            if (this.completed) {
                this.setLocalResult(this.getEmptyResult());
            }
        }

        private Node<P_OUT> doTruncate(Node<P_OUT> node) {
            long l = this.targetSize >= 0L ? Math.min(node.count(), this.targetOffset + this.targetSize) : this.thisNodeSize;
            return node.truncate(this.targetOffset, l, this.generator);
        }

        private boolean isLeftCompleted(long l) {
            long l2;
            long l3 = l2 = this.completed ? this.thisNodeSize : this.completedSize(l);
            if (l2 >= l) {
                return true;
            }
            SliceTask sliceTask = this;
            for (SliceTask sliceTask2 = (SliceTask)this.getParent(); sliceTask2 != null; sliceTask2 = (SliceTask)sliceTask2.getParent()) {
                SliceTask sliceTask3;
                if (sliceTask == sliceTask2.rightChild && (sliceTask3 = (SliceTask)sliceTask2.leftChild) != null && (l2 += sliceTask3.completedSize(l)) >= l) {
                    return true;
                }
                sliceTask = sliceTask2;
            }
            return l2 >= l;
        }

        private long completedSize(long l) {
            if (this.completed) {
                return this.thisNodeSize;
            }
            SliceTask sliceTask = (SliceTask)this.leftChild;
            SliceTask sliceTask2 = (SliceTask)this.rightChild;
            if (sliceTask == null || sliceTask2 == null) {
                return this.thisNodeSize;
            }
            long l2 = sliceTask.completedSize(l);
            return l2 >= l ? l2 : l2 + sliceTask2.completedSize(l);
        }
    }
}

