/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NGShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class Rectangle
extends Shape {
    private final RoundRectangle2D shape = new RoundRectangle2D();
    private static final int NON_RECTILINEAR_TYPE_MASK = -80;
    private DoubleProperty x;
    private DoubleProperty y;
    private final DoubleProperty width = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Rectangle.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Rectangle.this;
        }

        @Override
        public String getName() {
            return "width";
        }
    };
    private final DoubleProperty height = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Rectangle.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Rectangle.this;
        }

        @Override
        public String getName() {
            return "height";
        }
    };
    private DoubleProperty arcWidth;
    private DoubleProperty arcHeight;

    public Rectangle() {
    }

    public Rectangle(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public Rectangle(double width, double height, Paint fill) {
        this.setWidth(width);
        this.setHeight(height);
        this.setFill(fill);
    }

    public Rectangle(double x, double y, double width, double height) {
        this(width, height);
        this.setX(x);
        this.setY(y);
    }

    public final void setX(double value) {
        if (this.x != null || value != 0.0) {
            this.xProperty().set(value);
        }
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Rectangle.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Rectangle.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        if (this.y != null || value != 0.0) {
            this.yProperty().set(value);
        }
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Rectangle.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Rectangle.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setWidth(double value) {
        this.width.set(value);
    }

    public final double getWidth() {
        return this.width.get();
    }

    public final DoubleProperty widthProperty() {
        return this.width;
    }

    public final void setHeight(double value) {
        this.height.set(value);
    }

    public final double getHeight() {
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        return this.height;
    }

    public final void setArcWidth(double value) {
        if (this.arcWidth != null || value != 0.0) {
            this.arcWidthProperty().set(value);
        }
    }

    public final double getArcWidth() {
        return this.arcWidth == null ? 0.0 : this.arcWidth.get();
    }

    public final DoubleProperty arcWidthProperty() {
        if (this.arcWidth == null) {
            this.arcWidth = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                }

                @Override
                public CssMetaData<Rectangle, Number> getCssMetaData() {
                    return StyleableProperties.ARC_WIDTH;
                }

                @Override
                public Object getBean() {
                    return Rectangle.this;
                }

                @Override
                public String getName() {
                    return "arcWidth";
                }
            };
        }
        return this.arcWidth;
    }

    public final void setArcHeight(double value) {
        if (this.arcHeight != null || value != 0.0) {
            this.arcHeightProperty().set(value);
        }
    }

    public final double getArcHeight() {
        return this.arcHeight == null ? 0.0 : this.arcHeight.get();
    }

    public final DoubleProperty arcHeightProperty() {
        if (this.arcHeight == null) {
            this.arcHeight = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                }

                @Override
                public CssMetaData<Rectangle, Number> getCssMetaData() {
                    return StyleableProperties.ARC_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return Rectangle.this;
                }

                @Override
                public String getName() {
                    return "arcHeight";
                }
            };
        }
        return this.arcHeight;
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        return new NGRectangle();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Rectangle.getClassCssMetaData();
    }

    @Override
    StrokeLineJoin convertLineJoin(StrokeLineJoin t) {
        if (this.getArcWidth() > 0.0 && this.getArcHeight() > 0.0) {
            return StrokeLineJoin.BEVEL;
        }
        return t;
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        double upad;
        double dpad;
        if (this.impl_mode == NGShape.Mode.EMPTY) {
            return bounds.makeEmpty();
        }
        if (this.getArcWidth() > 0.0 && this.getArcHeight() > 0.0 && (tx.getType() & 0xFFFFFFB0) != 0) {
            return this.computeShapeBounds(bounds, tx, this.impl_configShape());
        }
        if (this.impl_mode == NGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
            dpad = 0.0;
            upad = 0.0;
        } else {
            upad = this.getStrokeWidth();
            if (this.getStrokeType() == StrokeType.CENTERED) {
                upad /= 2.0;
            }
            dpad = 0.0;
        }
        return this.computeBounds(bounds, tx, upad, dpad, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    @Deprecated
    public RoundRectangle2D impl_configShape() {
        if (this.getArcWidth() > 0.0 && this.getArcHeight() > 0.0) {
            this.shape.setRoundRect((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), (float)this.getArcWidth(), (float)this.getArcHeight());
        } else {
            this.shape.setRoundRect((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), 0.0f, 0.0f);
        }
        return this.shape;
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            NGRectangle peer = (NGRectangle)this.impl_getPeer();
            peer.updateRectangle((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), (float)this.getArcWidth(), (float)this.getArcHeight());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Rectangle[");
        String id = this.getId();
        if (id != null) {
            sb.append("id=").append(id).append(", ");
        }
        sb.append("x=").append(this.getX());
        sb.append(", y=").append(this.getY());
        sb.append(", width=").append(this.getWidth());
        sb.append(", height=").append(this.getHeight());
        sb.append(", fill=").append(this.getFill());
        Paint stroke = this.getStroke();
        if (stroke != null) {
            sb.append(", stroke=").append(stroke);
            sb.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return sb.append("]").toString();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Rectangle, Number> ARC_HEIGHT = new CssMetaData<Rectangle, Number>("-fx-arc-height", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Rectangle node) {
                return node.arcHeight == null || !node.arcHeight.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Rectangle node) {
                return (StyleableProperty)((Object)node.arcHeightProperty());
            }
        };
        private static final CssMetaData<Rectangle, Number> ARC_WIDTH = new CssMetaData<Rectangle, Number>("-fx-arc-width", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Rectangle node) {
                return node.arcWidth == null || !node.arcWidth.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Rectangle node) {
                return (StyleableProperty)((Object)node.arcWidthProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Shape.getClassCssMetaData());
            styleables.add(ARC_HEIGHT);
            styleables.add(ARC_WIDTH);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

